import { system, world, ItemStack, GameMode } from '@minecraft/server';

const hoeIds = [
    'v360:emerald_hoe'
]
const shovelIds = [
    'v360:emerald_shovel'
]
const axeIds = [
    'v360:emerald_axe'
]
const chiselId = [
    'v360:chisel'
]
const whistleId = [
    'v360:ancient_whistle'
]

world.beforeEvents.itemUseOn.subscribe(evd => {
    const { source: player, block, itemStack: itemUsed } = evd;
    if (!itemUsed) return;

    const pickaxeIds = [
        player.getComponent('equippable').getEquipment('Mainhand').hasTag('minecraft:is_pickaxe')
    ]

    if (hoeIds.includes(itemUsed.typeId) || shovelIds.includes(itemUsed.typeId) || axeIds.includes(itemUsed.typeId) || chiselId.includes(itemUsed.typeId) || pickaxeIds.includes(itemUsed.typeId)) {
        const playerEquippableComp = player.getComponent("equippable");
        if (!playerEquippableComp) return;
        if (hoeIds.includes(itemUsed.typeId)) {
            const blockAbove = block.dimension.getBlock(block.location).above(1);
            if (!blockAbove.isAir) return;
            if (block.permutation.matches('minecraft:dirt') || block.permutation.matches('minecraft:grass_block') || block.permutation.matches('minecraft:dirt_with_roots')) {
                system.run(function () {
                    player.playSound('use.gravel', { pitch: 1, location: block.location, volume: 1 });
                })
            }
            else return;
        }

        if (shovelIds.includes(itemUsed.typeId)) {
            const blockAbove = block.dimension.getBlock(block.location).above(1);
            if (!blockAbove.isAir) return;
            if (block.permutation.matches('minecraft:dirt') || block.permutation.matches('minecraft:grass_block') || block.permutation.matches('minecraft:dirt_with_roots') || block.permutation.matches('minecraft:mycelium') || block.permutation.matches('minecraft:podzol')) {
                if (!block.permutation.matches('minecraft:grass_block')) {
                    system.run(function () {
                        block.setType("minecraft:grass_path");
                    })
                }
                system.run(function () {
                    player.playSound('use.grass', { pitch: 1, location: block.location, volume: 0.5 });
                })
            }
            else return;
        }

        if (pickaxeIds.includes(itemUsed.typeId)) {
            if (block.hasTag('v360:lamp_should_dim'))
                system.run(function () {
                    block.dimension.playSound('block.copper_bulb.turn_on', block.location)
                })
            else return
        }

        if (axeIds.includes(itemUsed.typeId)) {
            if (block.permutation.matches('minecraft:oak_log') || block.permutation.matches('minecraft:birch_log') || block.permutation.matches('minecraft:spruce_log') || block.permutation.matches('minecraft:dark_oak_log') || block.permutation.matches('minecraft:jungle_log') || block.permutation.matches('minecraft:acacia_log') || block.permutation.matches('minecraft:mangrove_log') || block.permutation.matches('v360:araucaria_log') || block.permutation.matches('v360:end_log') || block.permutation.matches('minecraft:oak_wood') || block.permutation.matches('minecraft:birch_wood') || block.permutation.matches('minecraft:spruce_wood') || block.permutation.matches('minecraft:dark_oak_wood') || block.permutation.matches('minecraft:jungle_wood') || block.permutation.matches('minecraft:acacia_wood') || block.permutation.matches('minecraft:mangrove_wood') || block.permutation.matches('v360:araucaria_wood') || block.permutation.matches('v360:end_wood'))
                system.run(function () {
                    player.playSound('use.wood', { pitch: 1, location: block.location, volume: 1 })
                })
            else if (block.permutation.matches('minecraft:cherry_log') || block.permutation.matches('minecraft:cherry_wood'))
                system.run(function () {
                    player.playSound('step.cherry_wood', { pitch: 1, location: block.location, volume: 1 })
                })
            else if (block.permutation.matches('minecraft:bamboo_block'))
                system.run(function () {
                    player.playSound('step.bamboo_wood', { pitch: 1, location: block.location, volume: 1 })
                })
            else if (block.permutation.matches('minecraft:crimson_stem') || block.permutation.matches('minecraft:warped_stem') || block.permutation.matches('minecraft:crimson_hyphae') || block.permutation.matches('minecraft:warped_hyphae'))
                system.run(function () {
                    player.playSound('use.stem', { pitch: 1, location: block.location, volume: 1 })
                })
            else if (block.hasTag('v360:copper'))
                system.run(function () { })
            else return;

        }

        if (chiselId.includes(itemUsed.typeId)) {
            if (block.permutation.matches('v360:cracked_deepslate') || block.permutation.matches('v360:cracked_stone') || block.permutation.matches('minecraft:stone') || block.permutation.matches('minecraft:polished_deepslate') || block.permutation.matches('minecraft:polished_blackstone') || block.permutation.matches('minecraft:nether_brick') || block.permutation.matches('minecraft:polished_tuff') || block.permutation.matches('minecraft:tuff_bricks') || block.permutation.matches('v360:polished_calcite') || block.permutation.matches('v360:polished_amphibolite') || block.permutation.matches('v360:polished_limestone') || block.permutation.matches('v360:dripstone_bricks') || block.permutation.matches('v360:polished_rootstone') || block.hasTag('v360:bronze_statue') || block.permutation.matches('v360:amethyst_chiseled_smooth_basalt_bricks') || block.permutation.matches('v360:citrine_chiseled_smooth_basalt_bricks') || block.permutation.matches('v360:garnet_chiseled_smooth_basalt_bricks') || block.permutation.matches('v360:jade_chiseled_smooth_basalt_bricks')) {
                system.run(function () {
                    player.playSound('block.stonecutter.use', { pitch: 1, location: block.location, volume: 1 });
                })
            }
            else return;
        }

        if (player.matches({ gameMode: GameMode.creative })) return;
        const itemEnchantmentComp = itemUsed.getComponent("minecraft:enchantable");
        const unbreakingLevel = itemEnchantmentComp?.getEnchantment("unbreaking")?.level ?? 0;
        const breakChance = 100 / (unbreakingLevel + 1);
        const randomizeChance = Math.random() * 100;
        if (breakChance < randomizeChance) return;
        const itemUsedDurabilityComp = itemUsed.getComponent("durability");
        if (!itemUsedDurabilityComp) return;
        system.run(function () {
            const maxDurability = itemUsedDurabilityComp.maxDurability
            const currentDamage = itemUsedDurabilityComp.damage
            if (currentDamage >= maxDurability) {
                system.run(() => {
                    player.playSound('random.break', { pitch: 1, location: player.location, volume: 1 })
                    playerEquippableComp.setEquipment("Mainhand", new ItemStack('minecraft:air', 1));
                });
            }
            else if (currentDamage < maxDurability) {
                system.run(() => {
                    itemUsedDurabilityComp.damage += 1;
                    playerEquippableComp.setEquipment("Mainhand", itemUsed);
                });
            }
        })
    }
})

world.beforeEvents.itemUse.subscribe(evd => {
    const { source: player, block, itemStack: itemUsed } = evd;
    if (!itemUsed) return;

    if (whistleId.includes(itemUsed.typeId) && !player.getItemCooldown('ancient_whistle')) {
        const playerEquippableComp = player.getComponent("equippable");
        if (!playerEquippableComp) return;
        if (player.matches({ gameMode: GameMode.creative })) return;
        const itemEnchantmentComp = itemUsed.getComponent("minecraft:enchantable");
        const unbreakingLevel = itemEnchantmentComp?.getEnchantment("unbreaking")?.level ?? 0;
        const breakChance = 100 / (unbreakingLevel + 1);
        const randomizeChance = Math.random() * 100;
        if (breakChance < randomizeChance) return;
        const itemUsedDurabilityComp = itemUsed.getComponent("durability");
        if (!itemUsedDurabilityComp) return;
        system.run(function () {
            const maxDurability = itemUsedDurabilityComp.maxDurability
            const currentDamage = itemUsedDurabilityComp.damage
            if (currentDamage >= maxDurability) {
                system.run(() => {
                    player.playSound('random.break', { pitch: 1, location: player.location, volume: 1 })
                    playerEquippableComp.setEquipment("Mainhand", new ItemStack('minecraft:air', 1));
                });
            }
            else if (currentDamage < maxDurability) {
                system.run(() => {
                    itemUsedDurabilityComp.damage += 1;
                    playerEquippableComp.setEquipment("Mainhand", itemUsed);
                });
            }
        })
    }
})